/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.text.RubyRegexpAutoIndentStrategy;
import com.aptana.editor.ruby.RubyEditorPlugin;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

class RubyAutoIndentStrategy
extends RubyRegexpAutoIndentStrategy {
    private final Pattern openBlockPattern = Pattern.compile(".*[\\S].*do[\\w|\\s]*");
    private static final String BLOCK_CLOSER = "end";

    RubyAutoIndentStrategy(String contentType, SourceViewerConfiguration configuration, ISourceViewer sourceViewer, IPreferenceStore prefStore) {
        super(contentType, configuration, sourceViewer, prefStore);
    }

    protected boolean autoIndent(IDocument d, DocumentCommand c) {
        boolean superAutoIndent = super.autoIndent(d, c);
        int p = Math.max(0, c.offset == d.getLength() ? c.offset - 1 : c.offset);
        int line = 0;
        IRegion currentLineRegion = null;
        int startOfCurrentLine = 0;
        String lineString = null;
        try {
            line = d.getLineOfOffset(p);
            currentLineRegion = d.getLineInformation(line);
            startOfCurrentLine = currentLineRegion.getOffset();
            lineString = d.get(startOfCurrentLine, c.offset - startOfCurrentLine);
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)RubyEditorPlugin.getDefault(), (String)("Unable to get text of line at offset: " + p), (Throwable)e);
            return false;
        }
        if (!superAutoIndent) {
            if (lineString.startsWith("=begin")) {
                String indent = this.getIndentString();
                c.text = String.valueOf(c.text) + indent;
                c.caretOffset = c.offset + indent.length();
                c.shiftsCaret = false;
                c.text = String.valueOf(c.text) + TextUtilities.getDefaultLineDelimiter((IDocument)d) + "=end";
                return true;
            }
            return false;
        }
        String trimmed = lineString.trim();
        if (trimmed.equals("=begin")) {
            String indent = this.getIndentString();
            c.text = String.valueOf(c.text) + indent;
            c.caretOffset = c.offset + indent.length();
            c.shiftsCaret = false;
            c.text = String.valueOf(c.text) + TextUtilities.getDefaultLineDelimiter((IDocument)d) + "=end";
        }
        if (this.closeBlock() && this.unclosedBlock(d, trimmed, c.offset)) {
            String previousLineIndent = this.getAutoIndentAfterNewLine(d, c);
            c.text = String.valueOf(c.text) + TextUtilities.getDefaultLineDelimiter((IDocument)d) + previousLineIndent + BLOCK_CLOSER;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean unclosedBlock(IDocument d, String trimmed, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK], 28[CATCHBLOCK], 25[CATCHBLOCK]], but top level block is 12[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean atStartOfBlock(String line) {
        return line.startsWith("class ") || line.startsWith("if ") || line.startsWith("while ") || line.startsWith("module ") || line.startsWith("unless ") || line.startsWith("def ") || line.equals("begin") || line.startsWith("case ") || line.startsWith("for ") || this.openBlockPattern.matcher(line).matches();
    }

    private boolean closeBlock() {
        return true;
    }
}

